
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    int     i, m, p, numPolys;
    poly    *z, temp;
    char    *xString;
    clock_t start, end;
    char    *outString;
    
    double elapsed;

again:
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    
    //cin.ignore();  // needed for next cin with prompt to behave
    
    m = 0;
    while(m<1)
    {
        cout << "m: ";
        cin >> m;
    }
    cout << endl;
    /*
    findPrimitivePolys(outString, m, p);
    cout << outString << endl;
    return 0;
     */
    
    start = clock();
    if(!(findPrimitivePolys(z, numPolys, m, p)))
    {
       cout << "failed" << endl << endl;
       goto again;
    }
    end = clock();
    elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
    
    if(numPolys>1)
        cout << "primitive polynomials:" << endl;
    else
        cout << "primitive polynomial:" << endl;
    
    for(i=0;i<numPolys;++i)
    {
        temp = z[i];
        polyConvToxString(xString, temp);
        cout << xString << endl;
    }
    cout << endl;
    cout << "elapsed time = " << elapsed << " sec" << endl << endl;
    
    goto again;
    
    return 0;
}
// bool findPrimitivePolys(poly*& z, int& numPolys, int m, double p)
/*
 #include <time.h>
 
 clock_t start, end;
 double elapsed;
 
 start = clock();

end = clock();
elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
 */
